package gov.va.med.mhv.phr.chemlabs.decorator;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.phr.transfer.ChemLabsTest;

import java.io.Serializable;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class ChemLabsTestDetailsDecorator implements Serializable {

	private static final long serialVersionUID = 1L;
	protected static final String UNKNOWN = 
        StringEscapeUtils.escapeHtml("Unknown");
    private final ChemLabsTest test;    
	
    @SuppressWarnings("unchecked")
    public ChemLabsTestDetailsDecorator(ChemLabsTest test) {
        Precondition.assertNotNull("test", test);
        this.test = test;
    }
    
	public String getLabTestName() {
		if(test!=null && (!StringUtils.isEmpty(test.getLabTestName()))){
			return test.getLabTestName().trim();
		}else{
			return UNKNOWN;
		}	
	}
	
	public String getResult() {
		  String value = "";
		  if (test != null) {
		   if (!StringUtils.isEmpty(test.getResults())) {
		    value += test.getResults() + " ";
		   }
		   if (!StringUtils.isEmpty(test.getResultIndicator())) {
		    value += test.getResultIndicator();
		   }
		   return value;
		  }
		  return "";
	}
	
	public String getReferenceRange() {
		if(test!=null && (!StringUtils.isEmpty(test.getReferenceRange()))){
			return test.getReferenceRange().trim();
		}else{
			return "";
		}
	}	
	
	public String getUnits() {
		if(test!=null && null != test.getUnits()){
			return test.getUnits().trim();
		}else{
			return "";
		}	
	}	
	
	public String getPerformingLocation() {
		if(test!=null && null != test.getPerformingLocation()){
			return test.getPerformingLocation().trim();
		}else{
			return UNKNOWN;
		}	
	}
	
	public String getStatus() {
		if(test!=null && null != test.getStatus()){
			return test.getStatus().trim();
		}else{
			return UNKNOWN;
		}	
	}
	
	public String getInterpretation() {
		if(test!=null && null != test.getInterpretation()){
			return test.getInterpretation();
		}else{
			return "";
		}	
	}	

}